//This file is part of FiveIMSNickCollinsPhD. Copyright (C) 2006  Nicholas M.Collins distributed under the terms of the GNU General Public License full notice in file FiveIMSNickCollinsPhD.help

//Nick Collins created 20/1/05

SatatSitar {
	var s; 
	var node1,trackgroup, synthgroup, fxgroup;
	var pitchdetect, onsetdetect;
	var <citchbuffer,<citchdata,<ampdata, pastfreqs, pfcount;
	var l, inbus, sourceindex, events, task;
	
	//update GUI for Nikki
	var w, progress, pitchtrack, status, instruction, flicker; 
		
	
	*new{arg l,debug=false, starttime=0.0;
		^super.new.initSatatSitar(l,debug, starttime);
	}
	
	initSatatSitar {arg livecode, debug, starttime;
		var b, source, readytask, condition;
		
		l=livecode;
		
		s=Server.default;
		s.latency=0.04;
		
		//might need to force this stuff to head of RootNode to be compatable with LiveCoding1
		node1= Node.basicNew(s,1);
		
		trackgroup= Group.head(node1);
		synthgroup= Group.after(trackgroup);
		fxgroup= Group.after(synthgroup);
		
		//so can switch inputs on the fly
		~sourcebus= Bus.control(s,1);
		sourceindex=8; //standard mono audio input
		
		if(debug,{
		//for debug, will remove later
		source=Bus.audio(s,1);

		sourceindex= source.index;

		~debugvol=Bus.control(s,1);

		~debugvol.set(0.5); 
		
		b=Buffer.read(s,"/Volumes/data/audio/nikkisitar/warmup.wav"); //sitar test file, try anything you have 
		
		Synth.head(trackgroup, \satatsitardebug,[\bufnum, b.bufnum, \sourceindex,sourceindex,\amp,~debugvol.index]);
		
		});
		
		~sourcebus.set(sourceindex);
		
		//clears all SC setup
		//currentEnvironment.clear;
		//s.freeAll;
		//initialise, remove all existing OSCresponderNodes for triggers
		//OSCresponder.all.do({arg val; if(val.cmdName=='/tr',{OSCresponder.remove(val)}); }

	
		condition= Condition.new;
		
		Routine.run({
		
		s.sync(condition);	
		this.initTracking;
		s.sync(condition);		
		{this.initGUI;}.defer;
		s.sync(condition);
		this.initComposition(starttime);
		s.sync(condition);
		//this.startTracking(~sourcebus.index);
		//s.sync(condition);
		});

		"initialised SatAtSitar".postln;

//
//		readytask= Task({
//
//		0.5.wait;
//		this.initTracking;
//		0.5.wait;
//		this.initGUI;
//		0.5.wait;
//		this.initComposition(starttime);
//		
//		"initialised SatAtSitar".postln;
//		}, AppClock);
//		
//		readytask.start;
		
		
	}
	
	//make a status window for Nikki
	initGUI {
		var halfx, halfy, quartery;
		
			//probably unused?
		~sitar2dslid=LC2DSliderWindow.new("sitar2d");
		//set x to not maximal position!
		~sitar2dslid.set(0.5,0.0); //initial position
	
	
		halfx=400;
		halfy=halfx.div(2);
		quartery= halfy.div(2);
	
		w= SCWindow("Sat At Sitar",Rect(300,0,2*halfx,halfx));
	
		progress= SCRangeSlider(w,Rect(halfx+5,30,halfx-10,30)); 
		
		progress.lo_(0).hi_(0);
		
		//hold vals for last ten seconds, 20 per second
		pitchtrack = SCMultiSliderView(w, Rect(5,halfy+5,2*200,halfy-10)); 
		pitchtrack.value_(Array.fill(200,0));
		pitchtrack.isFilled_(false);
		pitchtrack.valueThumbSize_(2.0);
		pitchtrack.indexThumbSize_(2.0);
		pitchtrack.gap_(0);
		
		status=SCStaticText(w,Rect(5,5,halfx-10,quartery-10)).string_("status").font_(Font(\Arial,24));
		instruction=SCStaticText(w,Rect(5,quartery+5,halfx-10,quartery-10)).string_("welcome to SAT AT SITAR").font_(Font(\Arial,24));
		
		flicker=SCStaticText(w,Rect(halfx+halfy,halfy+55,50,50)).string_("<>").font_(Font(\Arial, 36));
	
		w.front;
	}
	
	//will load any Buffers automatically
	initBuffers {arg source, breakarray, samparray;
	
		//sourcebuf=Buffer.read(s, source);

	
	}
	
	initTracking {
		var amptmp;
		//harmonic beat induction would be useful for the finale?
		//do as a Task so timed gradually?
				
		//instance variables, not global Environment?	
				
		//simple capture of 16 beats= 8 sec at default tempo 2bps
		~cap1= LCAudioCapture1(l, 1, 16); 		
		~cap2= LCAudioCapture1(l, 1, 16); 		
		~cap3= LCAudioCapture1(l, 1, 16); 		
				
		//pitch detect
		~pdfreq=Bus.control(s,1);
		~pdhasFreq= Bus.control(s,1);
		~pdfreq.set(440);
		~pdhasFreq.set(1);
		~onsets= Bus.audio(s,1); //audio(s,1);
		
		//won't work for audio bus 
		~onsets.set(0.0);

		//set up Qitch
		citchbuffer = Buffer.read(s, "QspeckernN4096SR44100.wav"); 
		//this line is absolutely essential! You must load the data required by the UGen! 

		citchdata=Buffer.alloc(s,12,1);

		ampdata=Buffer.alloc(s,11,1);
		
		//no wonder different bahaviour on some of the tracking! no, tis OK, passed -1
		//amptmp= #[2.4752,0.6265,2.7614,0.5581,0.1380,0.0355,1.3222,0.5486,0.2173,0.1038,0.0133];
		
		//wrong harmonic template should be 1 going down to 0.6
		ampdata.setn(0,amptmp); //must have 11 components
		
		
		//send out osc, adjust to your local machine, sending to Max/MSP
		//~fredrik=NetAddr("169.254.29.94", 9999); 
		//~oscout= BBCSOSCOut(-1,~fredrik);

		//using with LiveCoding1
		~ce= CaptureEventsManager(oscout:(LCTempoControl.oscout));

		~ce.capturebus.set(sourceindex);
		
		
	}
	
	//delay before creation to allow for buffer initialisation, stagger setup for safety
			
	startTracking {
		var lowfreq, highfreq, freqdiff, siz;
		//ampdata.bufnum, -1
		pitchdetect= Synth.tail(trackgroup,\pitchdetect,[\sourcebus,~sourcebus.index, \citchbufnum,citchbuffer.bufnum,\databufnum,citchdata.bufnum, \ampbufnum,-1, \freqbus, ~pdfreq.index,\hasfreqbus,~pdhasFreq.index, \scorethreshold, 130]);
	
		onsetdetect= Synth.tail(trackgroup,\onsetdetect, [\sourcebus,~sourcebus.index,\thresholdbus,~sitar2dslid.xind,\onsetbus, ~onsets.index]);
		
		//run histogramming of chord content at 20 per second (could do 40 but higher CPU cost)
		~citchhistogramflag=true;
		
		lowfreq= 48;
		highfreq= 84;
		freqdiff= highfreq-lowfreq;
		
		siz= (freqdiff+1)*5;
		
		~citchhistogram= Array.fill(siz,{0});
		~citchfreq= 440;
		~citchscore=0.0;
		
		pastfreqs= Array.fill(200,{0});
		pfcount=0;
			
		SystemClock.sched(0.0,{
			
			~citchhistogram= ~citchhistogram*0.5; //reduce it every round
			
			citchdata.getn(0,12,{arg data; 
			var score,freq;
			
			score=data[11];
			freq=data[10];
			
			//freq.postln;
			
			data= (data.copyRange(0,9).cpsmidi.round(0.2));
			
			data= (((data-lowfreq).max(0).min(freqdiff))*5).asInteger;
			
			data.do({arg val, i; ~citchhistogram[val]= ~citchhistogram[val]+(0.025*(10-i)); });
			
			//freq= freq.cpsmidi.round(0.2);
			
			//freq= (((freq-lowfreq).max(0).min(freqdiff))*5)/siz;
			
			~citchfreq=freq;
			~citchscore=score;
			
			//[data[0], score, freq,freq.cpsmidi].postln;
			pastfreqs[pfcount]=((freq.cpsmidi).max(48)-48)/24;
			//pastfreqs[pfcount].postln;
			pfcount=(pfcount+1)%200;
			
			//update every sec to save CPU
			if(pfcount%20==0,{
			{pitchtrack.value_(pastfreqs);}.defer
			});
			
			});
		
			if(~citchhistogramflag,0.05,nil)
		});
		
		//better values for sitar- need to do some tests
		~ce.spreadbus.set(7);
		~ce.slopebus.set(0.1);
		
		~ce.play2(trackgroup); //CaptureEvents2 UGen
		
		//~ce.run(false);
		//~pitchdetect.run(false);
		//~onsetdetect.run(false);
	
		//flash up discovered rhythms
		this.indicateRhythms;
		
		//reverb unit on output?
		
	
	}
	
	
	indicateRhythms {
		var done, currlist;
		
		done=1;
		
		currlist=List.new;
		
		AppClock.sched(1.0,{
			
			done=done+1;
			
			if(done>=currlist.size,{
			currlist=~ce.rhythmlist.copy;
			done=0;
			});
			
			flicker.string_("<>");
			
			//may clash for very short IOIs but not a big problem
			AppClock.sched(0.02,{flicker.string_("");});
			
			currlist.wrapAt(done);
		});
		
	}
	
	
	//if want to track a captured sample rather than sourceindex for instance
	swapsource {arg newindex;
	
		~ce.capturebus.set(newindex);
		~sourcebus.set(newindex);
	}
	
	
	//l is the live coding environment
	initComposition {arg starttime=0.0;
	var firsteventindex, alap, gat, jhala;
	var jhalastart,gatstart;
	
	//alap= thisProcess.interpreter.executeFile("/Volumes/data/sc3code/composition/concertfeb21/alap.rtf");

	
//~cap1.record(8); 
//leave running for outro too
//l.addnf(\captureloop, {~cap1.sf.loopForSynthDef},0.0,1);
//captrack=l.gettracknum(\captureloop)
//~sourcebus.set(l.tracks[captrack].bus.index);

	events=[];
	
	//each section in a different function as + SatAtSitar{  alap{} }
	
	//ALAP
	alap=this.alap;
	
//GAT, 10 minutes
gat=this.gat;
	
//JHALA, 5 minutes
jhala=this.jhala; 

Post << "pre gat" << gat <<nl; 

gatstart= 420.0;
gat.do({arg val; val[0]= val[0]+gatstart;});

Post << "post gat" << gat <<nl; 

jhalastart= 900.0;
jhala.do({arg val; val[0]= val[0]+jhalastart;});

	
	events=alap++gat++jhala;
			
	Post << events <<nl; 
		
	alap[0].postln;
	events[0].postln;	
		
	///sort into order
	events = events.sort({ arg a, b; a[0] < b[0] });


	if(starttime>0.001,{
	firsteventindex= 1.neg;
	events.do({arg val,j; if(val[0]<starttime,{firsteventindex=j;});});
	
	firsteventindex=firsteventindex+1;
	
	events= events.copyRange(firsteventindex,events.size);
	
	events.do({arg val; val[0]=val[0]-starttime;});
	});
	
	Post << events <<nl; 
	
	//turn into iois
	
	(events.size-1).do({arg j; 
	
	events[j][0]= events[j+1][0]-events[j][0];
	});
	
	events[events.size-1][0]=0.0; //dummy event to close
		
	//Post << events <<nl; 	
		
	}


	//SystemClock scheduling, 1 per second 
	progressupdate {arg length;
		var done,todo;
		
		//"progress".postln;
		
		//length.postln;
		
		done=0;
		todo=floor(length).asInteger-1;
		
		//todo.postln;
		
		SystemClock.sched(0.0,{
		var pos;
		
		pos= (done.asFloat/todo);
		
		//pos.postln;
		
		{progress.hi_(pos);}.defer;
		
		done=done+1;
		if(done<todo,1.0,nil)
		});
		
	
	}

	
	//schedule events on an IOI basis 
	run {
	var clock;
	
	//don't use AppClock, not accurate o/w! 
	clock=TempoClock(1); //like a SystemClock, saves deferring all GUI calls, not going to run event scheduling on this directly
		
	task=Task({
	
	//[ioi,eventdata]
	events.do({arg event,i;
	var eventdata;
	
	eventdata.postln;
	
	eventdata=event[1];
	
	if(eventdata.isKindOf(Array),{l.addenvnf(eventdata[0],eventdata[1],0.0,1,eventdata[2])},{eventdata.value;});
	
	event[0].wait;
	});
	
	}, clock);
	
	task.start;
	
	//AppClock.play(task);
		
	}
	
	
	stop {
		~citchhistogramflag=false;
		task.stop;
		l.stop;
		w.close;
		~sitar2dslid.close;
		s.freeAll;
		SystemClock.clear;
		AppClock.clear;
	}
	
	
	
	//SynthDefs for tracking and setup
	*initClass {
		
		StartUp.add({
			
		//modify for Qitch- higher latency, better resolution
		SynthDef.writeOnce(\pitchdetect,{arg sourcebus,citchbufnum,databufnum,ampbufnum,freqbus, hasfreqbus,scorethreshold;
		var in, freq, hasFreq;
		
		in= InFeedback.ar(In.kr(sourcebus,1),1); 
		# freq, hasFreq = Citch.kr(in,citchbufnum,0.02,databufnum,ampbufnum,150,1500, scorethreshold);
		
		//PrintVal.kr(freq,100,101);
		
		Out.kr(freqbus,freq);
		Out.kr(hasfreqbus,hasFreq);
		
		});
		
		
		SynthDef.writeOnce(\onsetdetect,{arg sourcebus, thresholdbus, onsetbus;
		var in, onsets;
		
		in= InFeedback.ar(In.kr(sourcebus,1),1); 
		Out.ar(onsetbus,OnsetDetection.ar(in,LinLin.kr(In.kr(thresholdbus,1),0.0,1.0,0.1,1.3)));
		
		});
		
		
		SynthDef.writeOnce(\satatsitardebug,{arg bufnum,sourceindex,amp;
		var pb;
		
		pb= PlayBuf.ar(1,bufnum, loop:1);
				
		Out.ar(sourceindex,pb);
				
		Out.ar(0,Pan2.ar(pb*In.kr(amp),0.0));
		});
		

		//thisProcess.interpreter.executeFile("/Volumes/data/sc3code/composition/concertfeb21/alapsynthdefs.rtf");
		//thisProcess.interpreter.executeFile("/Volumes/data/sc3code/composition/concertfeb21/gatsynthdefs.rtf");
	
		});
	
	}

}